/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWStepDeadlinePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWStepDeadlineTab
extends JPanel
implements IVWPropertyTab,
ActionListener,
IVWMapChangedListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDef = null;
    private VWToolbarBorder m_deadlineBorder = null;
    private VWStepDeadlinePanel m_deadlinePanel = null;
    private VWToolbarBorder m_deadlineMapBorder = null;
    private JComboBox m_deadlineMapComboBox = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        this.m_authPropertyData = authPropertyData;
        this.createControls(vwMapNode);
        this.setSelectedStep(vwMapNode);
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        try {
            if (this.m_stepDef != null && this.m_stepDef == vwMapNode) {
                return;
            }
            this.m_stepDef = (VWStepDefinition)vwMapNode;
            if (this.m_stepDef != null) {
                String deadlineMap = this.m_stepDef.getDeadlineMap();
                this.m_deadlineMapComboBox.removeActionListener(this);
                if (deadlineMap != null) {
                    this.m_deadlineMapComboBox.setSelectedItem(deadlineMap);
                } else {
                    this.m_deadlineMapComboBox.setSelectedItem(VWResource.s_noneItemStr);
                }
                this.m_deadlineMapComboBox.addActionListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        if (this.m_deadlineBorder != null) {
            this.m_deadlineBorder.releaseReferences();
            this.m_deadlineBorder = null;
        }
        if (this.m_deadlinePanel != null) {
            this.m_deadlinePanel.removeAll();
            this.m_deadlinePanel = null;
        }
        if (this.m_deadlineMapBorder != null) {
            this.m_deadlineMapBorder.releaseReferences();
            this.m_deadlineMapBorder = null;
        }
        if (this.m_deadlineMapComboBox != null) {
            this.m_deadlineMapComboBox.removeActionListener(this);
            this.m_deadlineMapComboBox.removeAll();
            this.m_deadlineMapComboBox = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_deadlineMapComboBox)) {
                this.performDeadlineSubmapComboBox();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: {
                this.initDeadlineSubmapComboBox();
                break;
            }
            case 517: 
            case 519: {
                this.initDeadlineSubmapComboBox();
                this.setSelectedStep(this.m_stepDef);
            }
        }
    }

    private void createControls(VWMapNode vwMapNode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 19;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            this.add((Component)this.getDeadlinePanel(vwMapNode), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.add((Component)this.getDeadlineSubmapPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDeadlinePanel(VWMapNode vwMapNode) {
        try {
            this.m_deadlineBorder = new VWToolbarBorder(VWResource.s_deadlineStr, 0);
            JPanel clientPanel = this.m_deadlineBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_deadlinePanel = new VWStepDeadlinePanel();
            this.m_deadlinePanel.init(this.m_authPropertyData, vwMapNode);
            clientPanel.add((Component)this.m_deadlinePanel, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_deadlineBorder;
    }

    private JPanel getDeadlineSubmapPanel() {
        try {
            this.m_deadlineMapBorder = new VWToolbarBorder(VWResource.s_deadlineSubmap);
            JPanel clientPanel = this.m_deadlineMapBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_deadlineMapComboBox = new JComboBox();
            this.m_deadlineMapComboBox.setName("m_deadlineMapComboBox_VWStepDeadlinePanel");
            this.m_deadlineMapComboBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_deadlineMapComboBox.addActionListener(this);
            clientPanel.add((Component)this.m_deadlineMapComboBox, "First");
            this.initDeadlineSubmapComboBox();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_deadlineMapBorder;
    }

    private void initDeadlineSubmapComboBox() {
        Object[] mapNames = null;
        Vector<String> mapNamesVec = new Vector<String>();
        this.m_deadlineMapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                Object mapName;
                int i;
                this.m_deadlineMapComboBox.removeAllItems();
                this.m_deadlineMapComboBox.addItem(VWResource.s_noneItemStr);
                this.m_deadlineMapComboBox.addItem("Workflow");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (i = 0; i < len; ++i) {
                        mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare((String)mapName, "Workflow") == 0) continue;
                        mapNamesVec.addElement((String)mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQuickSort sortMap = new VWQuickSort(mapNames, 0);
                    sortMap.sort(0, mapNames.length - 1);
                    for (i = 0; i < mapNames.length; ++i) {
                        mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        this.m_deadlineMapComboBox.addItem(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_deadlineMapComboBox.addActionListener(this);
    }

    private void performDeadlineSubmapComboBox() {
        try {
            String mapName = (String)this.m_deadlineMapComboBox.getSelectedItem();
            if (VWStringUtils.compare(mapName, VWResource.s_noneItemStr) == 0) {
                this.m_stepDef.setDeadlineMap(null);
            } else {
                this.m_stepDef.setDeadlineMap(mapName);
            }
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

